import sys
import math

def main():
    input = sys.stdin.readline

    n = int(input())
    x = list(map(int, input().split()))
    h = list(map(int, input().split()))

    L = [-1] * n
    R = [-1] * n

    stack = []
    for i in range(n):
        while stack and h[stack[-1]] < h[i]:
            stack.pop()
        if stack:
            L[i] = stack[-1]
        stack.append(i)

    stack.clear()
    for i in range(n - 1, -1, -1):
        while stack and h[stack[-1]] < h[i]:
            stack.pop()
        if stack:
            R[i] = stack[-1]
        stack.append(i)

    SQRT2 = math.sqrt(2)
    out = []

    for i in range(n):
        best = float('inf')

        if L[i] != -1:
            dx = x[i] - x[L[i]]
            dy = h[i] - h[L[i]]
            best = min(best, math.hypot(dx, dy))

        if R[i] != -1:
            dx = x[i] - x[R[i]]
            dy = h[i] - h[R[i]]
            best = min(best, math.hypot(dx, dy))

        if i > 0 and max(h[i], h[i-1]) >= h[i]:
            best = min(best, SQRT2 * abs(h[i-1] - h[i]))

        if i + 1 < n and max(h[i], h[i+1]) >= h[i]:
            best = min(best, SQRT2 * abs(h[i+1] - h[i]))

        if best == float('inf'):
            out.append("-1")
        else:
            out.append(f"{best:.10f}")

    sys.stdout.write("\n".join(out))


if __name__ == "__main__":
    main()